import COMMANDS from './commands';
import { RedisCommand, RedisCommandArguments, RedisCommandRawReply, RedisModules, RedisPlugins, RedisScript, RedisScripts } from '../commands';
import RedisMultiCommand, { RedisMultiQueuedCommand } from '../multi-command';
declare type RedisClientMultiCommandSignature<C extends RedisCommand, M extends RedisModules, S extends RedisScripts> = (...args: Parameters<C['transformArguments']>) => RedisClientMultiCommandType<M, S>;
declare type WithCommands<M extends RedisModules, S extends RedisScripts> = {
    [P in keyof typeof COMMANDS]: RedisClientMultiCommandSignature<(typeof COMMANDS)[P], M, S>;
};
declare type WithModules<M extends RedisModules, S extends RedisScripts> = {
    [P in keyof M as M[P] extends never ? never : P]: {
        [C in keyof M[P]]: RedisClientMultiCommandSignature<M[P][C], M, S>;
    };
};
declare type WithScripts<M extends RedisModules, S extends RedisScripts> = {
    [P in keyof S as S[P] extends never ? never : P]: RedisClientMultiCommandSignature<S[P], M, S>;
};
export declare type RedisClientMultiCommandType<M extends RedisModules = Record<string, never>, S extends RedisScripts = Record<string, never>> = RedisClientMultiCommand & WithCommands<M, S> & WithModules<M, S> & WithScripts<M, S>;
export declare type RedisClientMultiExecutor = (queue: Array<RedisMultiQueuedCommand>, chainId?: symbol) => Promise<Array<RedisCommandRawReply>>;
export default class RedisClientMultiCommand {
    #private;
    static extend<M extends RedisModules, S extends RedisScripts>(plugins?: RedisPlugins<M, S>): new (...args: ConstructorParameters<typeof RedisMultiCommand>) => RedisClientMultiCommandType<M, S>;
    readonly v4: Record<string, any>;
    constructor(executor: RedisClientMultiExecutor, legacyMode?: boolean);
    commandsExecutor(command: RedisCommand, args: Array<unknown>): this;
    addCommand(args: RedisCommandArguments, transformReply?: RedisCommand['transformReply']): this;
    scriptsExecutor(script: RedisScript, args: Array<unknown>): this;
    exec(execAsPipeline?: boolean): Promise<Array<RedisCommandRawReply>>;
    EXEC: (execAsPipeline?: boolean) => Promise<Array<RedisCommandRawReply>>;
    execAsPipeline(): Promise<Array<RedisCommandRawReply>>;
}
export {};
