/// <reference types="node" />
import { CommandOptions } from './command-options';
import { RedisCommand, RedisCommandArguments, RedisCommandRawReply, RedisCommandReply, RedisCommands, RedisModules, RedisScript, RedisScripts } from './commands';
declare type Instantiable<T = any> = new (...args: Array<any>) => T;
interface ExtendWithCommandsConfig<T extends Instantiable> {
    BaseClass: T;
    commands: RedisCommands;
    executor(command: RedisCommand, args: Array<unknown>): unknown;
}
export declare function extendWithCommands<T extends Instantiable>({ BaseClass, commands, executor }: ExtendWithCommandsConfig<T>): void;
interface ExtendWithModulesAndScriptsConfig<T extends Instantiable> {
    BaseClass: T;
    modules?: RedisModules;
    modulesCommandsExecutor(this: InstanceType<T>, command: RedisCommand, args: Array<unknown>): unknown;
    scripts?: RedisScripts;
    scriptsExecutor(this: InstanceType<T>, script: RedisScript, args: Array<unknown>): unknown;
}
export declare function extendWithModulesAndScripts<T extends Instantiable>(config: ExtendWithModulesAndScriptsConfig<T>): T;
export declare function transformCommandArguments<T = unknown>(command: RedisCommand, args: Array<unknown>): {
    args: RedisCommandArguments;
    options: CommandOptions<T> | undefined;
};
export declare function encodeCommand(args: RedisCommandArguments): IterableIterator<string | Buffer>;
export declare function transformCommandReply(command: RedisCommand, rawReply: RedisCommandRawReply, preserved: unknown): RedisCommandReply<typeof command>;
export declare type LegacyCommandArguments = Array<string | number | Buffer | LegacyCommandArguments>;
export declare function transformLegacyCommandArguments(args: LegacyCommandArguments, flat?: RedisCommandArguments): RedisCommandArguments;
export {};
