"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.transformReply = exports.transformArguments = exports.IS_READ_ONLY = exports.FIRST_KEY_INDEX = void 0;
const generic_transformers_1 = require("@node-redis/client/dist/lib/commands/generic-transformers");
const _1 = require(".");
exports.FIRST_KEY_INDEX = 1;
exports.IS_READ_ONLY = true;
function transformArguments(index, query, options) {
    const args = ['FT.SEARCH', index, query];
    (0, _1.pushSearchOptions)(args, options);
    return args;
}
exports.transformArguments = transformArguments;
function transformReply(reply) {
    const documents = [];
    for (let i = 1; i < reply.length; i += 2) {
        const tuples = reply[i + 1];
        documents.push({
            id: reply[i],
            value: tuples.length === 2 && tuples[0] === '$' ?
                JSON.parse(tuples[1]) :
                (0, generic_transformers_1.transformReplyTuples)(tuples)
        });
    }
    return {
        total: reply[0],
        documents
    };
}
exports.transformReply = transformReply;
