"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.transformArguments = void 0;
const generic_transformers_1 = require("@node-redis/client/dist/lib/commands/generic-transformers");
const _1 = require(".");
function transformArguments(index, schema, options) {
    const args = ['FT.CREATE', index];
    if (options === null || options === void 0 ? void 0 : options.ON) {
        args.push('ON', options.ON);
    }
    (0, generic_transformers_1.pushOptionalVerdictArgument)(args, 'PREFIX', options === null || options === void 0 ? void 0 : options.PREFIX);
    if (options === null || options === void 0 ? void 0 : options.FILTER) {
        args.push('FILTER', options.FILTER);
    }
    if (options === null || options === void 0 ? void 0 : options.LANGUAGE) {
        args.push('LANGUAGE', options.LANGUAGE);
    }
    if (options === null || options === void 0 ? void 0 : options.LANGUAGE_FIELD) {
        args.push('LANGUAGE_FIELD', options.LANGUAGE_FIELD);
    }
    if (options === null || options === void 0 ? void 0 : options.SCORE) {
        args.push('SCORE', options.SCORE.toString());
    }
    if (options === null || options === void 0 ? void 0 : options.SCORE_FIELD) {
        args.push('SCORE_FIELD', options.SCORE_FIELD);
    }
    // if (options?.PAYLOAD_FIELD) {
    //     args.push('PAYLOAD_FIELD', options.PAYLOAD_FIELD);
    // }
    if (options === null || options === void 0 ? void 0 : options.MAXTEXTFIELDS) {
        args.push('MAXTEXTFIELDS');
    }
    if (options === null || options === void 0 ? void 0 : options.TEMPORARY) {
        args.push('TEMPORARY', options.TEMPORARY.toString());
    }
    if (options === null || options === void 0 ? void 0 : options.NOOFFSETS) {
        args.push('NOOFFSETS');
    }
    if (options === null || options === void 0 ? void 0 : options.NOHL) {
        args.push('NOHL');
    }
    if (options === null || options === void 0 ? void 0 : options.NOFIELDS) {
        args.push('NOFIELDS');
    }
    if (options === null || options === void 0 ? void 0 : options.NOFREQS) {
        args.push('NOFREQS');
    }
    if (options === null || options === void 0 ? void 0 : options.SKIPINITIALSCAN) {
        args.push('SKIPINITIALSCAN');
    }
    (0, generic_transformers_1.pushOptionalVerdictArgument)(args, 'STOPWORDS', options === null || options === void 0 ? void 0 : options.STOPWORDS);
    args.push('SCHEMA');
    (0, _1.pushSchema)(args, schema);
    return args;
}
exports.transformArguments = transformArguments;
