/// <reference types="node" />
import { RedisClientType } from '../client';
import { RedisClusterOptions } from '.';
import { RedisModules, RedisScripts } from '../commands';
export interface ClusterNode<M extends RedisModules, S extends RedisScripts> {
    id: string;
    client: RedisClientType<M, S>;
}
declare type OnError = (err: unknown) => void;
export default class RedisClusterSlots<M extends RedisModules, S extends RedisScripts> {
    #private;
    constructor(options: RedisClusterOptions<M, S>, onError: OnError);
    connect(): Promise<void>;
    rediscover(startWith: RedisClientType<M, S>): Promise<void>;
    getSlotMaster(slot: number): ClusterNode<M, S>;
    getClient(firstKey?: string | Buffer, isReadonly?: boolean): RedisClientType<M, S>;
    getMasters(): Array<ClusterNode<M, S>>;
    getNodeByUrl(url: string): ClusterNode<M, S> | undefined;
    disconnect(): Promise<void>;
}
export {};
