/// <reference types="node" />
import { RedisCommandArguments } from '.';
export declare function transformReplyBoolean(reply: number): boolean;
export declare function transformReplyBooleanArray(reply: Array<number>): Array<boolean>;
export declare type BitValue = 0 | 1;
export interface ScanOptions {
    MATCH?: string;
    COUNT?: number;
}
export declare function pushScanArguments(args: Array<string>, cursor: number, options?: ScanOptions): Array<string>;
export declare function transformReplyNumberInfinity(reply: string): number;
export declare function transformReplyNumberInfinityArray(reply: Array<string>): Array<number | null>;
export declare function transformReplyNumberInfinityNull(reply: string | null): number | null;
export declare function transformReplyNumberInfinityNullArray(reply: Array<string | null>): Array<number | null>;
export declare function transformArgumentNumberInfinity(num: number): string;
export declare function transformArgumentStringNumberInfinity(num: string | number): string;
export interface TuplesObject {
    [field: string]: string;
}
export declare function transformReplyTuples(reply: Array<string>): TuplesObject;
export interface StreamMessageReply {
    id: string;
    message: TuplesObject;
}
export declare type StreamMessagesReply = Array<StreamMessageReply>;
export declare function transformReplyStreamMessages(reply: Array<any>): StreamMessagesReply;
export declare type StreamsMessagesReply = Array<{
    name: string;
    messages: StreamMessagesReply;
}> | null;
export declare function transformReplyStreamsMessages(reply: Array<any> | null): StreamsMessagesReply | null;
export interface ZMember {
    score: number;
    value: string;
}
export declare function transformReplySortedSetWithScores(reply: Array<string>): Array<ZMember>;
declare type GeoCountArgument = number | {
    value: number;
    ANY?: true;
};
export declare function pushGeoCountArgument(args: Array<string>, count: GeoCountArgument | undefined): Array<string>;
export declare type GeoUnits = 'm' | 'km' | 'mi' | 'ft';
export interface GeoCoordinates {
    longitude: string | number;
    latitude: string | number;
}
declare type GeoSearchFromMember = string;
export declare type GeoSearchFrom = GeoSearchFromMember | GeoCoordinates;
interface GeoSearchByRadius {
    radius: number;
    unit: GeoUnits;
}
interface GeoSearchByBox {
    width: number;
    height: number;
    unit: GeoUnits;
}
export declare type GeoSearchBy = GeoSearchByRadius | GeoSearchByBox;
export interface GeoSearchOptions {
    SORT?: 'ASC' | 'DESC';
    COUNT?: GeoCountArgument;
}
export declare function pushGeoSearchArguments(args: Array<string>, key: string, from: GeoSearchFrom, by: GeoSearchBy, options?: GeoSearchOptions): Array<string>;
export declare enum GeoReplyWith {
    DISTANCE = "WITHDIST",
    HASH = "WITHHASH",
    COORDINATES = "WITHCOORD"
}
export interface GeoReplyWithMember {
    member: string;
    distance?: number;
    hash?: string;
    coordinates?: {
        longitude: string;
        latitude: string;
    };
}
export declare function transformGeoMembersWithReply(reply: Array<Array<any>>, replyWith: Array<GeoReplyWith>): Array<GeoReplyWithMember>;
export declare function transformEXAT(EXAT: number | Date): string;
export declare function transformPXAT(PXAT: number | Date): string;
export interface EvalOptions {
    keys?: Array<string>;
    arguments?: Array<string>;
}
export declare function pushEvalArguments(args: Array<string>, options?: EvalOptions): Array<string>;
export declare type StringTuplesArguments = Array<[string, string]> | Array<string> | Record<string, string>;
export declare function pushStringTuplesArguments(args: Array<string>, tuples: StringTuplesArguments): Array<string>;
export declare function pushVerdictArguments(args: RedisCommandArguments, value: string | Buffer | Array<string | Buffer>): RedisCommandArguments;
export declare function pushVerdictArgument(args: RedisCommandArguments, value: string | Array<string>): RedisCommandArguments;
export declare function pushOptionalVerdictArgument(args: RedisCommandArguments, name: string, value: undefined | string | Array<string>): RedisCommandArguments;
export declare enum CommandFlags {
    WRITE = "write",
    READONLY = "readonly",
    DENYOOM = "denyoom",
    ADMIN = "admin",
    PUBSUB = "pubsub",
    NOSCRIPT = "noscript",
    RANDOM = "random",
    SORT_FOR_SCRIPT = "sort_for_script",
    LOADING = "loading",
    STALE = "stale",
    SKIP_MONITOR = "skip_monitor",
    ASKING = "asking",
    FAST = "fast",
    MOVABLEKEYS = "movablekeys"
}
export declare enum CommandCategories {
    KEYSPACE = "@keyspace",
    READ = "@read",
    WRITE = "@write",
    SET = "@set",
    SORTEDSET = "@sortedset",
    LIST = "@list",
    HASH = "@hash",
    STRING = "@string",
    BITMAP = "@bitmap",
    HYPERLOGLOG = "@hyperloglog",
    GEO = "@geo",
    STREAM = "@stream",
    PUBSUB = "@pubsub",
    ADMIN = "@admin",
    FAST = "@fast",
    SLOW = "@slow",
    BLOCKING = "@blocking",
    DANGEROUS = "@dangerous",
    CONNECTION = "@connection",
    TRANSACTION = "@transaction",
    SCRIPTING = "@scripting"
}
export declare type CommandRawReply = [
    name: string,
    arity: number,
    flags: Array<CommandFlags>,
    firstKeyIndex: number,
    lastKeyIndex: number,
    step: number,
    categories: Array<CommandCategories>
];
export declare type CommandReply = {
    name: string;
    arity: number;
    flags: Set<CommandFlags>;
    firstKeyIndex: number;
    lastKeyIndex: number;
    step: number;
    categories: Set<CommandCategories>;
};
export declare function transformCommandReply(this: void, [name, arity, flags, firstKeyIndex, lastKeyIndex, step, categories]: CommandRawReply): CommandReply;
export {};
