import _babelRuntimeHelpersEsmExtends from "@babel/runtime/helpers/esm/extends";

/*
 * Copyright 2020 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
let $fe87f22deac4debf3eab2ca6a89602ab$var$formatterCache = new Map();
let $fe87f22deac4debf3eab2ca6a89602ab$var$supportsSignDisplay = false;

try {
  // @ts-ignore
  $fe87f22deac4debf3eab2ca6a89602ab$var$supportsSignDisplay = new Intl.NumberFormat('de-DE', {
    signDisplay: 'exceptZero'
  }).resolvedOptions().signDisplay === 'exceptZero'; // eslint-disable-next-line no-empty
} catch (e) {}

let $fe87f22deac4debf3eab2ca6a89602ab$var$supportsUnit = false;

try {
  // @ts-ignore
  $fe87f22deac4debf3eab2ca6a89602ab$var$supportsUnit = new Intl.NumberFormat('de-DE', {
    style: 'unit',
    unit: 'degree'
  }).resolvedOptions().style === 'unit'; // eslint-disable-next-line no-empty
} catch (e) {} // Polyfill for units since Safari doesn't support them yet. See https://bugs.webkit.org/show_bug.cgi?id=215438.
// Currently only polyfilling the unit degree in narrow format for ColorSlider in our supported locales.
// Values were determined by switching to each locale manually in Chrome.


const $fe87f22deac4debf3eab2ca6a89602ab$var$UNITS = {
  degree: {
    narrow: {
      default: '°',
      'ja-JP': ' 度',
      'zh-TW': '度',
      'sl-SI': ' °' // Arabic?? But Safari already doesn't use Arabic digits so might be ok...
      // https://bugs.webkit.org/show_bug.cgi?id=218139

    }
  }
};

/**
 * A wrapper around Intl.NumberFormat providing additional options, polyfills, and caching for performance.
 */
export class NumberFormatter {
  constructor(locale, options) {
    if (options === void 0) {
      options = {};
    }

    this.numberFormatter = void 0;
    this.options = void 0;
    this.numberFormatter = $fe87f22deac4debf3eab2ca6a89602ab$var$getCachedNumberFormatter(locale, options);
    this.options = options;
  }

  format(value) {
    let res = '';

    if (!$fe87f22deac4debf3eab2ca6a89602ab$var$supportsSignDisplay && this.options.signDisplay != null) {
      res = $fe87f22deac4debf3eab2ca6a89602ab$export$numberFormatSignDisplayPolyfill(this.numberFormatter, this.options.signDisplay, value);
    } else {
      res = this.numberFormatter.format(value);
    }

    if (this.options.style === 'unit' && !$fe87f22deac4debf3eab2ca6a89602ab$var$supportsUnit) {
      var _UNITS$unit;

      let {
        unit,
        unitDisplay = 'short',
        locale
      } = this.resolvedOptions();
      let values = (_UNITS$unit = $fe87f22deac4debf3eab2ca6a89602ab$var$UNITS[unit]) == null ? void 0 : _UNITS$unit[unitDisplay];
      res += values[locale] || values.default;
    }

    return res;
  }

  formatToParts(value) {
    // TODO: implement signDisplay for formatToParts
    // @ts-ignore
    return this.numberFormatter.formatToParts(value);
  }

  resolvedOptions() {
    let options = this.numberFormatter.resolvedOptions();

    if (!$fe87f22deac4debf3eab2ca6a89602ab$var$supportsSignDisplay && this.options.signDisplay != null) {
      options = _babelRuntimeHelpersEsmExtends({}, options, {
        signDisplay: this.options.signDisplay
      });
    }

    if (!$fe87f22deac4debf3eab2ca6a89602ab$var$supportsUnit && this.options.style === 'unit') {
      options = _babelRuntimeHelpersEsmExtends({}, options, {
        style: 'unit',
        unit: this.options.unit,
        unitDisplay: this.options.unitDisplay
      });
    }

    return options;
  }

}

function $fe87f22deac4debf3eab2ca6a89602ab$var$getCachedNumberFormatter(locale, options) {
  if (options === void 0) {
    options = {};
  }

  let {
    numberingSystem
  } = options;

  if (numberingSystem && locale.indexOf('-u-nu-') === -1) {
    locale = locale + "-u-nu-" + numberingSystem;
  }

  if (options.style === 'unit' && !$fe87f22deac4debf3eab2ca6a89602ab$var$supportsUnit) {
    var _UNITS$unit2;

    let {
      unit,
      unitDisplay = 'short'
    } = options;

    if (!unit) {
      throw new Error('unit option must be provided with style: "unit"');
    }

    if (!((_UNITS$unit2 = $fe87f22deac4debf3eab2ca6a89602ab$var$UNITS[unit]) != null && _UNITS$unit2[unitDisplay])) {
      throw new Error("Unsupported unit " + unit + " with unitDisplay = " + unitDisplay);
    }

    options = _babelRuntimeHelpersEsmExtends({}, options, {
      style: 'decimal'
    });
  }

  let cacheKey = locale + (options ? Object.entries(options).sort((a, b) => a[0] < b[0] ? -1 : 1).join() : '');

  if ($fe87f22deac4debf3eab2ca6a89602ab$var$formatterCache.has(cacheKey)) {
    return $fe87f22deac4debf3eab2ca6a89602ab$var$formatterCache.get(cacheKey);
  }

  let numberFormatter = new Intl.NumberFormat(locale, options);
  $fe87f22deac4debf3eab2ca6a89602ab$var$formatterCache.set(cacheKey, numberFormatter);
  return numberFormatter;
}
/** @private - exported for tests */


function $fe87f22deac4debf3eab2ca6a89602ab$export$numberFormatSignDisplayPolyfill(numberFormat, signDisplay, num) {
  if (signDisplay === 'auto') {
    return numberFormat.format(num);
  } else if (signDisplay === 'never') {
    return numberFormat.format(Math.abs(num));
  } else {
    let needsPositiveSign = false;

    if (signDisplay === 'always') {
      needsPositiveSign = num > 0 || Object.is(num, 0);
    } else if (signDisplay === 'exceptZero') {
      if (Object.is(num, -0) || Object.is(num, 0)) {
        num = Math.abs(num);
      } else {
        needsPositiveSign = num > 0;
      }
    }

    if (needsPositiveSign) {
      let negative = numberFormat.format(-num);
      let noSign = numberFormat.format(num); // ignore RTL/LTR marker character

      let minus = negative.replace(noSign, '').replace(/\u200e|\u061C/, '');

      if ([...minus].length !== 1) {
        console.warn('@react-aria/i18n polyfill for NumberFormat signDisplay: Unsupported case');
      }

      let positive = negative.replace(noSign, '!!!').replace(minus, '+').replace('!!!', noSign);
      return positive;
    } else {
      return numberFormat.format(num);
    }
  }
}

const $e1a22841ad5113a054c8ebe55b24e1a$var$CURRENCY_SIGN_REGEX = new RegExp('^.*\\(.*\\).*$');
const $e1a22841ad5113a054c8ebe55b24e1a$var$NUMBERING_SYSTEMS = ['latn', 'arab', 'hanidec'];
/**
 * A NumberParser can be used perform locale aware parsing of numbers from Unicode strings,
 * as well as validation of partial user input. Automatically detects the numbering system
 * used in the input, and supports parsing decimals, percentages, currency values, and units
 * according to the locale.
 */

export class NumberParser {
  constructor(locale, options) {
    if (options === void 0) {
      options = {};
    }

    this.locale = void 0;
    this.options = void 0;
    this.locale = locale;
    this.options = options;
  }
  /**
   * Parses the given string to a number. Returns NaN if a valid number could not be parsed.
   */


  parse(value) {
    return $e1a22841ad5113a054c8ebe55b24e1a$var$getNumberParserImpl(this.locale, this.options, value).parse(value);
  }
  /**
   * Returns whether the given string could potentially be a valid number. This should be used to
   * validate user input as the user types. If a `minValue` or `maxValue` is provided, the validity
   * of the minus/plus sign characters can be checked.
   */


  isValidPartialNumber(value, minValue, maxValue) {
    return $e1a22841ad5113a054c8ebe55b24e1a$var$getNumberParserImpl(this.locale, this.options, value).isValidPartialNumber(value, minValue, maxValue);
  }
  /**
   * Returns a numbering system for which the given string is valid in the current locale.
   * If no numbering system could be detected, the default numbering system for the current
   * locale is returned.
   */


  getNumberingSystem(value) {
    return $e1a22841ad5113a054c8ebe55b24e1a$var$getNumberParserImpl(this.locale, this.options, value).options.numberingSystem;
  }

}
const $e1a22841ad5113a054c8ebe55b24e1a$var$numberParserCache = new Map();

function $e1a22841ad5113a054c8ebe55b24e1a$var$getNumberParserImpl(locale, options, value) {
  // First try the default numbering system for the provided locale
  let defaultParser = $e1a22841ad5113a054c8ebe55b24e1a$var$getCachedNumberParser(locale, options); // If that doesn't match, and the locale doesn't include a hard coded numbering system,
  // try each of the other supported numbering systems until we find one that matches.

  if (!locale.includes('-nu-') && !defaultParser.isValidPartialNumber(value)) {
    for (let numberingSystem of $e1a22841ad5113a054c8ebe55b24e1a$var$NUMBERING_SYSTEMS) {
      if (numberingSystem !== defaultParser.options.numberingSystem) {
        let parser = $e1a22841ad5113a054c8ebe55b24e1a$var$getCachedNumberParser(locale + (locale.includes('-u-') ? '-nu-' : '-u-nu-') + numberingSystem, options);

        if (parser.isValidPartialNumber(value)) {
          return parser;
        }
      }
    }
  }

  return defaultParser;
}

function $e1a22841ad5113a054c8ebe55b24e1a$var$getCachedNumberParser(locale, options) {
  let cacheKey = locale + (options ? Object.entries(options).sort((a, b) => a[0] < b[0] ? -1 : 1).join() : '');
  let parser = $e1a22841ad5113a054c8ebe55b24e1a$var$numberParserCache.get(cacheKey);

  if (!parser) {
    parser = new $e1a22841ad5113a054c8ebe55b24e1a$var$NumberParserImpl(locale, options);
    $e1a22841ad5113a054c8ebe55b24e1a$var$numberParserCache.set(cacheKey, parser);
  }

  return parser;
} // The actual number parser implementation. Instances of this class are cached
// based on the locale, options, and detected numbering system.


class $e1a22841ad5113a054c8ebe55b24e1a$var$NumberParserImpl {
  constructor(locale, options) {
    if (options === void 0) {
      options = {};
    }

    this.formatter = void 0;
    this.options = void 0;
    this.symbols = void 0;
    this.formatter = new Intl.NumberFormat(locale, options);
    this.options = this.formatter.resolvedOptions();
    this.symbols = $e1a22841ad5113a054c8ebe55b24e1a$var$getSymbols(this.formatter, this.options, options);
  }

  parse(value) {
    // to parse the number, we need to remove anything that isn't actually part of the number, for example we want '-10.40' not '-10.40 USD'
    let fullySanitizedValue = this.sanitize(value); // Remove group characters, and replace decimal points and numerals with ASCII values.

    fullySanitizedValue = $e1a22841ad5113a054c8ebe55b24e1a$var$replaceAll(fullySanitizedValue, this.symbols.group, '').replace(this.symbols.decimal, '.').replace(this.symbols.minusSign, '-').replace(this.symbols.numeral, this.symbols.index);
    let newValue = fullySanitizedValue ? +fullySanitizedValue : NaN;

    if (isNaN(newValue)) {
      return NaN;
    } // accounting will always be stripped to a positive number, so if it's accounting and has a () around everything, then we need to make it negative again


    if (this.options.currencySign === 'accounting' && $e1a22841ad5113a054c8ebe55b24e1a$var$CURRENCY_SIGN_REGEX.test(value)) {
      newValue = -1 * newValue;
    } // when reading the number, if it's a percent, then it should be interpreted as being divided by 100


    if (this.options.style === 'percent') {
      var _this$options$maximum;

      newValue /= 100; // after dividing to get the percent value, javascript may get .0210999999 instead of .0211, so fix the number of fraction digits

      newValue = +newValue.toFixed(((_this$options$maximum = this.options.maximumFractionDigits) != null ? _this$options$maximum : 0) + 2);
    }

    return newValue;
  }

  sanitize(value) {
    // Remove literals and whitespace, which are allowed anywhere in the string
    value = value.replace(this.symbols.literals, ''); // Replace the ASCII minus sign with the minus sign used in the current locale
    // so that both are allowed in case the user's keyboard doesn't have the locale's minus sign.

    value = value.replace('-', this.symbols.minusSign); // In arab numeral system, their decimal character is 1643, but most keyboards don't type that
    // instead they use the , (44) character or apparently the (1548) character.

    if (this.options.numberingSystem === 'arab') {
      value = value.replace(',', this.symbols.decimal);
      value = value.replace(String.fromCharCode(1548), this.symbols.decimal);
      value = $e1a22841ad5113a054c8ebe55b24e1a$var$replaceAll(value, '.', this.symbols.group);
    } // fr-FR group character is char code 8239, but that's not a key on the french keyboard,
    // so allow 'period' as a group char and replace it with a space


    if (this.options.locale === 'fr-FR') {
      value = $e1a22841ad5113a054c8ebe55b24e1a$var$replaceAll(value, '.', String.fromCharCode(8239));
    }

    return value;
  }

  isValidPartialNumber(value, minValue, maxValue) {
    if (minValue === void 0) {
      minValue = -Infinity;
    }

    if (maxValue === void 0) {
      maxValue = Infinity;
    }

    value = this.sanitize(value); // Remove minus or plus sign, which must be at the start of the string.

    if (value.startsWith(this.symbols.minusSign) && minValue < 0) {
      value = value.slice(this.symbols.minusSign.length);
    } else if (this.symbols.plusSign && value.startsWith(this.symbols.plusSign) && maxValue > 0) {
      value = value.slice(this.symbols.plusSign.length);
    } // Numbers cannot start with a group separator


    if (value.startsWith(this.symbols.group)) {
      return false;
    } // Remove numerals, groups, and decimals


    value = $e1a22841ad5113a054c8ebe55b24e1a$var$replaceAll(value, this.symbols.group, '').replace(this.symbols.numeral, '').replace(this.symbols.decimal, ''); // The number is valid if there are no remaining characters

    return value.length === 0;
  }

}

const $e1a22841ad5113a054c8ebe55b24e1a$var$nonLiteralParts = new Set(['decimal', 'fraction', 'integer', 'minusSign', 'plusSign', 'group']);

function $e1a22841ad5113a054c8ebe55b24e1a$var$getSymbols(formatter, intlOptions, originalOptions) {
  var _allParts$find$value, _allParts$find, _posAllParts$find, _allParts$find2, _allParts$find3;

  // Note: some locale's don't add a group symbol until there is a ten thousands place
  let allParts = formatter.formatToParts(-10000.111);
  let posAllParts = formatter.formatToParts(10000.111);
  let singularParts = formatter.formatToParts(1);
  let minusSign = (_allParts$find$value = (_allParts$find = allParts.find(p => p.type === 'minusSign')) == null ? void 0 : _allParts$find.value) != null ? _allParts$find$value : '-';
  let plusSign = (_posAllParts$find = posAllParts.find(p => p.type === 'plusSign')) == null ? void 0 : _posAllParts$find.value; // Safari does not support the signDisplay option, but our number parser polyfills it.
  // If no plus sign was returned, but the original options contained signDisplay, default to the '+' character.
  // @ts-ignore

  if (!plusSign && ((originalOptions == null ? void 0 : originalOptions.signDisplay) === 'exceptZero' || (originalOptions == null ? void 0 : originalOptions.signDisplay) === 'always')) {
    plusSign = '+';
  }

  let decimal = (_allParts$find2 = allParts.find(p => p.type === 'decimal')) == null ? void 0 : _allParts$find2.value;
  let group = (_allParts$find3 = allParts.find(p => p.type === 'group')) == null ? void 0 : _allParts$find3.value; // this set is also for a regex, it's all literals that might be in the string we want to eventually parse that
  // don't contribute to the numerical value

  let pluralLiterals = allParts.filter(p => !$e1a22841ad5113a054c8ebe55b24e1a$var$nonLiteralParts.has(p.type)).map(p => $e1a22841ad5113a054c8ebe55b24e1a$var$escapeRegex(p.value));
  let singularLiterals = singularParts.filter(p => !$e1a22841ad5113a054c8ebe55b24e1a$var$nonLiteralParts.has(p.type)).map(p => $e1a22841ad5113a054c8ebe55b24e1a$var$escapeRegex(p.value));
  let sortedLiterals = [...new Set([...singularLiterals, ...pluralLiterals])].sort((a, b) => b.length - a.length);
  let literals = new RegExp(sortedLiterals.join('|') + "|[\\p{White_Space}]", 'gu'); // These are for replacing non-latn characters with the latn equivalent

  let numerals = [...new Intl.NumberFormat(intlOptions.locale, {
    useGrouping: false
  }).format(9876543210)].reverse();
  let indexes = new Map(numerals.map((d, i) => [d, i]));
  let numeral = new RegExp("[" + numerals.join('') + "]", 'g');

  let index = d => String(indexes.get(d));

  return {
    minusSign,
    plusSign,
    decimal,
    group,
    literals,
    numeral,
    index
  };
}

function $e1a22841ad5113a054c8ebe55b24e1a$var$replaceAll(str, find, replace) {
  // @ts-ignore
  if (str.replaceAll) {
    // @ts-ignore
    return str.replaceAll(find, replace);
  }

  return str.split(find).join(replace);
}

function $e1a22841ad5113a054c8ebe55b24e1a$var$escapeRegex(string) {
  return string.replace(/[-/\\^$*+?.()|[\]{}]/g, '\\$&');
}
//# sourceMappingURL=module.js.map
