/// <reference types="node" />
import { RedisCommandArguments } from '.';
declare type Types = string | number | Buffer;
declare type HSETObject = Record<string | number, Types>;
declare type HSETMap = Map<Types, Types>;
declare type HSETTuples = Array<[Types, Types]> | Array<Types>;
export declare const FIRST_KEY_INDEX = 1;
declare type GenericArguments = [key: string | Buffer];
declare type SingleFieldArguments = [...generic: GenericArguments, field: Types, value: Types];
declare type MultipleFieldsArguments = [...generic: GenericArguments, value: HSETObject | HSETMap | HSETTuples];
export declare function transformArguments(...[key, value, fieldValue]: SingleFieldArguments | MultipleFieldsArguments): RedisCommandArguments;
export declare function transformReply(): number;
export {};
