"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.transformCommandReply = exports.CommandCategories = exports.CommandFlags = exports.pushOptionalVerdictArgument = exports.pushVerdictArgument = exports.pushVerdictArguments = exports.pushStringTuplesArguments = exports.pushEvalArguments = exports.transformPXAT = exports.transformEXAT = exports.transformGeoMembersWithReply = exports.GeoReplyWith = exports.pushGeoSearchArguments = exports.pushGeoCountArgument = exports.transformReplySortedSetWithScores = exports.transformReplyStreamsMessages = exports.transformReplyStreamMessages = exports.transformReplyTuples = exports.transformArgumentStringNumberInfinity = exports.transformArgumentNumberInfinity = exports.transformReplyNumberInfinityNullArray = exports.transformReplyNumberInfinityNull = exports.transformReplyNumberInfinityArray = exports.transformReplyNumberInfinity = exports.pushScanArguments = exports.transformReplyBooleanArray = exports.transformReplyBoolean = void 0;
function transformReplyBoolean(reply) {
    return reply === 1;
}
exports.transformReplyBoolean = transformReplyBoolean;
function transformReplyBooleanArray(reply) {
    return reply.map(transformReplyBoolean);
}
exports.transformReplyBooleanArray = transformReplyBooleanArray;
function pushScanArguments(args, cursor, options) {
    args.push(cursor.toString());
    if (options === null || options === void 0 ? void 0 : options.MATCH) {
        args.push('MATCH', options.MATCH);
    }
    if (options === null || options === void 0 ? void 0 : options.COUNT) {
        args.push('COUNT', options.COUNT.toString());
    }
    return args;
}
exports.pushScanArguments = pushScanArguments;
function transformReplyNumberInfinity(reply) {
    switch (reply) {
        case '+inf':
            return Infinity;
        case '-inf':
            return -Infinity;
        default:
            return Number(reply);
    }
}
exports.transformReplyNumberInfinity = transformReplyNumberInfinity;
function transformReplyNumberInfinityArray(reply) {
    return reply.map(transformReplyNumberInfinity);
}
exports.transformReplyNumberInfinityArray = transformReplyNumberInfinityArray;
function transformReplyNumberInfinityNull(reply) {
    if (reply === null)
        return null;
    return transformReplyNumberInfinity(reply);
}
exports.transformReplyNumberInfinityNull = transformReplyNumberInfinityNull;
function transformReplyNumberInfinityNullArray(reply) {
    return reply.map(transformReplyNumberInfinityNull);
}
exports.transformReplyNumberInfinityNullArray = transformReplyNumberInfinityNullArray;
function transformArgumentNumberInfinity(num) {
    switch (num) {
        case Infinity:
            return '+inf';
        case -Infinity:
            return '-inf';
        default:
            return num.toString();
    }
}
exports.transformArgumentNumberInfinity = transformArgumentNumberInfinity;
function transformArgumentStringNumberInfinity(num) {
    if (typeof num === 'string')
        return num;
    return transformArgumentNumberInfinity(num);
}
exports.transformArgumentStringNumberInfinity = transformArgumentStringNumberInfinity;
function transformReplyTuples(reply) {
    const message = Object.create(null);
    for (let i = 0; i < reply.length; i += 2) {
        message[reply[i]] = reply[i + 1];
    }
    return message;
}
exports.transformReplyTuples = transformReplyTuples;
function transformReplyStreamMessages(reply) {
    const messages = [];
    for (const [id, message] of reply) {
        messages.push({
            id,
            message: transformReplyTuples(message)
        });
    }
    return messages;
}
exports.transformReplyStreamMessages = transformReplyStreamMessages;
function transformReplyStreamsMessages(reply) {
    if (reply === null)
        return null;
    return reply.map(([name, rawMessages]) => ({
        name,
        messages: transformReplyStreamMessages(rawMessages)
    }));
}
exports.transformReplyStreamsMessages = transformReplyStreamsMessages;
function transformReplySortedSetWithScores(reply) {
    const members = [];
    for (let i = 0; i < reply.length; i += 2) {
        members.push({
            value: reply[i],
            score: transformReplyNumberInfinity(reply[i + 1])
        });
    }
    return members;
}
exports.transformReplySortedSetWithScores = transformReplySortedSetWithScores;
function pushGeoCountArgument(args, count) {
    if (typeof count === 'number') {
        args.push('COUNT', count.toString());
    }
    else if (count) {
        args.push('COUNT', count.value.toString());
        if (count.ANY) {
            args.push('ANY');
        }
    }
    return args;
}
exports.pushGeoCountArgument = pushGeoCountArgument;
function pushGeoSearchArguments(args, key, from, by, options) {
    args.push(key);
    if (typeof from === 'string') {
        args.push('FROMMEMBER', from);
    }
    else {
        args.push('FROMLONLAT', from.longitude.toString(), from.latitude.toString());
    }
    if ('radius' in by) {
        args.push('BYRADIUS', by.radius.toString());
    }
    else {
        args.push('BYBOX', by.width.toString(), by.height.toString());
    }
    args.push(by.unit);
    if (options === null || options === void 0 ? void 0 : options.SORT) {
        args.push(options.SORT);
    }
    pushGeoCountArgument(args, options === null || options === void 0 ? void 0 : options.COUNT);
    return args;
}
exports.pushGeoSearchArguments = pushGeoSearchArguments;
var GeoReplyWith;
(function (GeoReplyWith) {
    GeoReplyWith["DISTANCE"] = "WITHDIST";
    GeoReplyWith["HASH"] = "WITHHASH";
    GeoReplyWith["COORDINATES"] = "WITHCOORD";
})(GeoReplyWith = exports.GeoReplyWith || (exports.GeoReplyWith = {}));
function transformGeoMembersWithReply(reply, replyWith) {
    const replyWithSet = new Set(replyWith);
    let index = 0;
    const distanceIndex = replyWithSet.has(GeoReplyWith.DISTANCE) && ++index, hashIndex = replyWithSet.has(GeoReplyWith.HASH) && ++index, coordinatesIndex = replyWithSet.has(GeoReplyWith.COORDINATES) && ++index;
    return reply.map(member => {
        const transformedMember = {
            member: member[0]
        };
        if (distanceIndex) {
            transformedMember.distance = member[distanceIndex];
        }
        if (hashIndex) {
            transformedMember.hash = member[hashIndex];
        }
        if (coordinatesIndex) {
            const [longitude, latitude] = member[coordinatesIndex];
            transformedMember.coordinates = {
                longitude,
                latitude
            };
        }
        return transformedMember;
    });
}
exports.transformGeoMembersWithReply = transformGeoMembersWithReply;
function transformEXAT(EXAT) {
    return (typeof EXAT === 'number' ? EXAT : Math.floor(EXAT.getTime() / 1000)).toString();
}
exports.transformEXAT = transformEXAT;
function transformPXAT(PXAT) {
    return (typeof PXAT === 'number' ? PXAT : PXAT.getTime()).toString();
}
exports.transformPXAT = transformPXAT;
function pushEvalArguments(args, options) {
    if (options === null || options === void 0 ? void 0 : options.keys) {
        args.push(options.keys.length.toString(), ...options.keys);
    }
    else {
        args.push('0');
    }
    if (options === null || options === void 0 ? void 0 : options.arguments) {
        args.push(...options.arguments);
    }
    return args;
}
exports.pushEvalArguments = pushEvalArguments;
function pushStringTuplesArguments(args, tuples) {
    if (Array.isArray(tuples)) {
        args.push(...tuples.flat());
    }
    else {
        for (const key of Object.keys(tuples)) {
            args.push(key, tuples[key]);
        }
    }
    return args;
}
exports.pushStringTuplesArguments = pushStringTuplesArguments;
function pushVerdictArguments(args, value) {
    if (Array.isArray(value)) {
        args.push(...value);
    }
    else {
        args.push(value);
    }
    return args;
}
exports.pushVerdictArguments = pushVerdictArguments;
function pushVerdictArgument(args, value) {
    if (typeof value === 'string') {
        args.push('1', value);
    }
    else {
        args.push(value.length.toString(), ...value);
    }
    return args;
}
exports.pushVerdictArgument = pushVerdictArgument;
function pushOptionalVerdictArgument(args, name, value) {
    if (value === undefined)
        return args;
    args.push(name);
    return pushVerdictArgument(args, value);
}
exports.pushOptionalVerdictArgument = pushOptionalVerdictArgument;
var CommandFlags;
(function (CommandFlags) {
    CommandFlags["WRITE"] = "write";
    CommandFlags["READONLY"] = "readonly";
    CommandFlags["DENYOOM"] = "denyoom";
    CommandFlags["ADMIN"] = "admin";
    CommandFlags["PUBSUB"] = "pubsub";
    CommandFlags["NOSCRIPT"] = "noscript";
    CommandFlags["RANDOM"] = "random";
    CommandFlags["SORT_FOR_SCRIPT"] = "sort_for_script";
    CommandFlags["LOADING"] = "loading";
    CommandFlags["STALE"] = "stale";
    CommandFlags["SKIP_MONITOR"] = "skip_monitor";
    CommandFlags["ASKING"] = "asking";
    CommandFlags["FAST"] = "fast";
    CommandFlags["MOVABLEKEYS"] = "movablekeys"; // keys have no pre-determined position. You must discover keys yourself.
})(CommandFlags = exports.CommandFlags || (exports.CommandFlags = {}));
var CommandCategories;
(function (CommandCategories) {
    CommandCategories["KEYSPACE"] = "@keyspace";
    CommandCategories["READ"] = "@read";
    CommandCategories["WRITE"] = "@write";
    CommandCategories["SET"] = "@set";
    CommandCategories["SORTEDSET"] = "@sortedset";
    CommandCategories["LIST"] = "@list";
    CommandCategories["HASH"] = "@hash";
    CommandCategories["STRING"] = "@string";
    CommandCategories["BITMAP"] = "@bitmap";
    CommandCategories["HYPERLOGLOG"] = "@hyperloglog";
    CommandCategories["GEO"] = "@geo";
    CommandCategories["STREAM"] = "@stream";
    CommandCategories["PUBSUB"] = "@pubsub";
    CommandCategories["ADMIN"] = "@admin";
    CommandCategories["FAST"] = "@fast";
    CommandCategories["SLOW"] = "@slow";
    CommandCategories["BLOCKING"] = "@blocking";
    CommandCategories["DANGEROUS"] = "@dangerous";
    CommandCategories["CONNECTION"] = "@connection";
    CommandCategories["TRANSACTION"] = "@transaction";
    CommandCategories["SCRIPTING"] = "@scripting";
})(CommandCategories = exports.CommandCategories || (exports.CommandCategories = {}));
function transformCommandReply([name, arity, flags, firstKeyIndex, lastKeyIndex, step, categories]) {
    return {
        name,
        arity,
        flags: new Set(flags),
        firstKeyIndex,
        lastKeyIndex,
        step,
        categories: new Set(categories)
    };
}
exports.transformCommandReply = transformCommandReply;
