'use strict';

module.exports = {
  actions: [
    {
      uid: 'marketplace.read',
      displayName: 'Access the marketplace',
      pluginName: 'admin',
      section: 'settings',
      category: 'plugins and marketplace',
      subCategory: 'marketplace',
    },
    {
      uid: 'marketplace.plugins.install',
      displayName: 'Install (only for dev env)',
      pluginName: 'admin',
      section: 'settings',
      category: 'plugins and marketplace',
      subCategory: 'plugins',
    },
    {
      uid: 'marketplace.plugins.uninstall',
      displayName: 'Uninstall (only for dev env)',
      pluginName: 'admin',
      section: 'settings',
      category: 'plugins and marketplace',
      subCategory: 'plugins',
    },
    {
      uid: 'webhooks.create',
      displayName: 'Create',
      pluginName: 'admin',
      section: 'settings',
      category: 'webhooks',
    },
    {
      uid: 'webhooks.read',
      displayName: 'Read',
      pluginName: 'admin',
      section: 'settings',
      category: 'webhooks',
    },
    {
      uid: 'webhooks.update',
      displayName: 'Update',
      pluginName: 'admin',
      section: 'settings',
      category: 'webhooks',
    },
    {
      uid: 'webhooks.delete',
      displayName: 'Delete',
      pluginName: 'admin',
      section: 'settings',
      category: 'webhooks',
    },
    {
      uid: 'users.create',
      displayName: 'Create (invite)',
      pluginName: 'admin',
      section: 'settings',
      category: 'users and roles',
      subCategory: 'users',
    },
    {
      uid: 'users.read',
      displayName: 'Read',
      pluginName: 'admin',
      section: 'settings',
      category: 'users and roles',
      subCategory: 'users',
    },
    {
      uid: 'users.update',
      displayName: 'Update',
      pluginName: 'admin',
      section: 'settings',
      category: 'users and roles',
      subCategory: 'users',
    },
    {
      uid: 'users.delete',
      displayName: 'Delete',
      pluginName: 'admin',
      section: 'settings',
      category: 'users and roles',
      subCategory: 'users',
    },
    {
      uid: 'roles.create',
      displayName: 'Create',
      pluginName: 'admin',
      section: 'settings',
      category: 'users and roles',
      subCategory: 'roles',
    },
    {
      uid: 'roles.read',
      displayName: 'Read',
      pluginName: 'admin',
      section: 'settings',
      category: 'users and roles',
      subCategory: 'roles',
    },
    {
      uid: 'roles.update',
      displayName: 'Update',
      pluginName: 'admin',
      section: 'settings',
      category: 'users and roles',
      subCategory: 'roles',
    },
    {
      uid: 'roles.delete',
      displayName: 'Delete',
      pluginName: 'admin',
      section: 'settings',
      category: 'users and roles',
      subCategory: 'roles',
    },
    {
      uid: 'api-tokens.create',
      displayName: 'Create (generate)',
      pluginName: 'admin',
      section: 'settings',
      category: 'api tokens',
    },
    {
      uid: 'api-tokens.read',
      displayName: 'Read',
      pluginName: 'admin',
      section: 'settings',
      category: 'api tokens',
    },
    {
      uid: 'api-tokens.update',
      displayName: 'Update',
      pluginName: 'admin',
      section: 'settings',
      category: 'api tokens',
    },
    {
      uid: 'api-tokens.delete',
      displayName: 'Delete (revoke)',
      pluginName: 'admin',
      section: 'settings',
      category: 'api tokens',
    },
  ],
};
