"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");

var _Object$defineProperty = require("@babel/runtime-corejs3/core-js-stable/object/define-property");

_Object$defineProperty(exports, "__esModule", {
  value: true
});

exports.default = _default;

var _assign = _interopRequireDefault(require("@babel/runtime-corejs3/core-js-stable/object/assign"));

var _isArray = _interopRequireDefault(require("@babel/runtime-corejs3/core-js-stable/array/is-array"));

var _map = _interopRequireDefault(require("@babel/runtime-corejs3/core-js-stable/instance/map"));

var _some = _interopRequireDefault(require("@babel/runtime-corejs3/core-js-stable/instance/some"));

var _filter = _interopRequireDefault(require("@babel/runtime-corejs3/core-js-stable/instance/filter"));

var _find = _interopRequireDefault(require("@babel/runtime-corejs3/core-js-stable/instance/find"));

var _includes = _interopRequireDefault(require("@babel/runtime-corejs3/core-js-stable/instance/includes"));

/* ========================================================================
 * PROMPT BYPASSING
 * -----------------
 * this allows a user to bypass a prompt by supplying input before
 * the prompts are run. we handle input differently depending on the
 * type of prompt that's in play (ie "y" means "true" for a confirm prompt)
 * ======================================================================== */
/////
// HELPER FUNCTIONS
//
// pull the "value" out of a choice option
const getChoiceValue = choice => {
  const isObject = typeof choice === 'object';

  if (isObject && choice.value != null) {
    return choice.value;
  }

  if (isObject && choice.name != null) {
    return choice.name;
  }

  if (isObject && choice.key != null) {
    return choice.key;
  }

  return choice;
}; // check if the choice value matches the bypass value


function checkChoiceValue(choiceValue, value) {
  return typeof choiceValue === 'string' && choiceValue.toLowerCase() === value.toLowerCase();
} // check if a bypass value matches some aspect of
// a particular choice option (index, value, key, etc)


function choiceMatchesValue(choice, choiceIdx, value) {
  return checkChoiceValue(choice, value) || checkChoiceValue(choice.value, value) || checkChoiceValue(choice.key, value) || checkChoiceValue(choice.name, value) || checkChoiceValue(choiceIdx.toString(), value);
} // check if a value matches a particular set of flagged input options


const isFlag = (list, v) => (0, _includes.default)(list).call(list, v.toLowerCase()); // input values that represent different types of responses


const flag = {
  isTrue: v => isFlag(['yes', 'y', 'true', 't'], v),
  isFalse: v => isFlag(['no', 'n', 'false', 'f'], v),
  isPrompt: v => /^_+$/.test(v)
}; // generic list bypass function. used for all types of lists.
// accepts value, index, or key as matching criteria

const listTypeBypass = (v, prompt) => {
  var _context;

  const choice = (0, _find.default)(_context = prompt.choices).call(_context, (c, idx) => choiceMatchesValue(c, idx, v));

  if (choice != null) {
    return getChoiceValue(choice);
  }

  throw Error('invalid choice');
}; /////
// BYPASS FUNCTIONS
//
// list of prompt bypass functions by prompt type


const typeBypass = {
  confirm(v) {
    if (flag.isTrue(v)) {
      return true;
    }

    if (flag.isFalse(v)) {
      return false;
    }

    throw Error('invalid input');
  },

  checkbox(v, prompt) {
    const valList = v.split(',');
    const valuesNoMatch = (0, _filter.default)(valList).call(valList, val => {
      var _context2;

      return !(0, _some.default)(_context2 = prompt.choices).call(_context2, (c, idx) => choiceMatchesValue(c, idx, val));
    });

    if (valuesNoMatch.length) {
      throw Error(`no match for "${valuesNoMatch.join('", "')}"`);
    }

    return (0, _map.default)(valList).call(valList, val => {
      var _context3;

      return getChoiceValue((0, _find.default)(_context3 = prompt.choices).call(_context3, (c, idx) => choiceMatchesValue(c, idx, val)));
    });
  },

  list: listTypeBypass,
  rawlist: listTypeBypass,
  expand: listTypeBypass
}; /////
// MAIN LOGIC
//
// returns new prompts, initial answers object, and any failures

function _default(prompts, bypassArr, plop) {
  const noop = [prompts, {}, []]; // bail out if we don't have prompts or bypass data

  if (!(0, _isArray.default)(prompts)) {
    return noop;
  }

  if (bypassArr.length === 0) {
    return noop;
  } // pull registered prompts out of inquirer


  const {
    prompts: inqPrompts
  } = plop.inquirer.prompt;
  const answers = {};
  const bypassFailures = []; // generate a list of pompts that the user is bypassing

  const bypassedPrompts = (0, _filter.default)(prompts).call(prompts, function (p, idx) {
    // if the user didn't provide value for this prompt, skip it
    if (idx >= bypassArr.length) {
      return false;
    }

    const val = bypassArr[idx].toString(); // if the user asked to be given this prompt, skip it

    if (flag.isPrompt(val)) {
      return false;
    } // if this prompt is dynamic, throw error because we can't know if
    // the pompt bypass values given line up with the path this user
    // has taken through the prompt tree.


    if (typeof p.when === 'function') {
      bypassFailures.push(`You can not bypass conditional prompts: ${p.name}`);
      return false;
    }

    try {
      const inqPrompt = inqPrompts[p.type] || {}; // try to find a bypass function to run

      const bypass = p.bypass || inqPrompt.bypass || typeBypass[p.type] || null; // get the real answer data out of the bypass function and attach it
      // to the answer data object

      const bypassIsFunc = typeof bypass === 'function';
      const value = bypassIsFunc ? bypass.call(null, val, p) : val; // if inquirer prompt has a filter function - call it

      const answer = (0, _filter.default)(p) ? (0, _filter.default)(p).call(p, value, answers) : value; // if inquirer prompt has a validate function - call it

      if (p.validate) {
        const validation = p.validate(value, answers);

        if (validation !== true) {
          // if validation failed return validation error
          bypassFailures.push(validation);
          return false;
        }
      }

      answers[p.name] = answer;
    } catch (err) {
      // if we encounter an error above... assume the bypass value was invalid
      bypassFailures.push(`The "${p.name}" prompt did not recognize "${val}" as a valid ${p.type} value (ERROR: ${err.message})`);
      return false;
    } // if we got this far, we successfully bypassed this prompt


    return true;
  }); // rip out any prompts that have been bypassed

  const promptsAfterBypass = [// first prompt will copy the bypass answer data so it's available
  // for prompts and actions to use
  {
    when: data => ((0, _assign.default)(data, answers), false)
  }, // inlcude any prompts that were NOT bypassed
  ...(0, _filter.default)(prompts).call(prompts, p => !(0, _includes.default)(bypassedPrompts).call(bypassedPrompts, p))]; // if we have failures, throw the first one

  if (bypassFailures.length) {
    throw Error(bypassFailures[0]);
  } else {
    // return the prompts that still need to be run
    return [promptsAfterBypass, answers];
  } // BOOM!

}