import * as React from 'react';
import { MessageDescriptor, CustomFormatConfig, FormatDateOptions } from '@formatjs/intl';
import { IntlListFormatOptions } from '@formatjs/intl-listformat';
import { DisplayNamesOptions } from '@formatjs/intl-displaynames';
import { DateTimeFormatOptions, NumberFormatOptions } from '@formatjs/ecma402-abstract';
export { IntlConfig, ResolvedIntlConfig, IntlShape } from './src/types';
export { createIntlCache, MessageDescriptor, IntlCache, Formatters, IntlFormatters, FormatDisplayNameOptions, FormatListOptions, FormatPluralOptions, FormatRelativeTimeOptions, FormatNumberOptions, FormatDateOptions, CustomFormatConfig, CustomFormats, UnsupportedFormatterError, InvalidConfigError, MissingDataError, MessageFormatError, MissingTranslationError, IntlErrorCode as ReactIntlErrorCode, IntlError as ReactIntlError, } from '@formatjs/intl';
export declare function defineMessages<K extends keyof any, T = MessageDescriptor, U extends Record<K, T> = Record<K, T>>(msgs: U): U;
export declare function defineMessage<T>(msg: T): T;
export { default as injectIntl, Provider as RawIntlProvider, Context as IntlContext, WithIntlProps, WrappedComponentProps, } from './src/components/injectIntl';
export { default as useIntl } from './src/components/useIntl';
export { default as IntlProvider, createIntl } from './src/components/provider';
export declare const FormattedDate: React.FC<DateTimeFormatOptions & CustomFormatConfig & {
    value: string | number | Date | undefined;
}>;
export declare const FormattedTime: React.FC<DateTimeFormatOptions & CustomFormatConfig & {
    value: string | number | Date | undefined;
}>;
export declare const FormattedNumber: React.FC<NumberFormatOptions & CustomFormatConfig & {
    value: number | bigint;
}>;
export declare const FormattedList: React.FC<IntlListFormatOptions & {
    value: readonly React.ReactNode[];
}>;
export declare const FormattedDisplayName: React.FC<DisplayNamesOptions & {
    value: string | number | Record<string, unknown>;
}>;
export declare const FormattedDateParts: React.FC<FormatDateOptions & {
    value: Parameters<Intl.DateTimeFormat['format']>[0] | string;
    children(val: Intl.DateTimeFormatPart[]): React.ReactElement | null;
}>;
export declare const FormattedTimeParts: React.FC<FormatDateOptions & {
    value: Parameters<Intl.DateTimeFormat['format']>[0] | string;
    children(val: Intl.DateTimeFormatPart[]): React.ReactElement | null;
}>;
export { FormattedNumberParts, FormattedListParts, } from './src/components/createFormattedComponent';
export { default as FormattedRelativeTime } from './src/components/relative';
export { default as FormattedPlural } from './src/components/plural';
export { default as FormattedMessage } from './src/components/message';
export { default as FormattedDateTimeRange } from './src/components/dateTimeRange';
export type { MessageFormatElement } from '@formatjs/icu-messageformat-parser';
//# sourceMappingURL=index.d.ts.map