/// <reference types="node" />
import COMMANDS from './commands';
import { RedisCommand, RedisCommandArguments, RedisCommandRawReply, RedisModules, RedisPlugins, RedisScript, RedisScripts } from '../commands';
import RedisMultiCommand, { RedisMultiQueuedCommand } from '../multi-command';
declare type RedisClusterMultiCommandSignature<C extends RedisCommand, M extends RedisModules, S extends RedisScripts> = (...args: Parameters<C['transformArguments']>) => RedisClusterMultiCommandType<M, S>;
declare type WithCommands<M extends RedisModules, S extends RedisScripts> = {
    [P in keyof typeof COMMANDS]: RedisClusterMultiCommandSignature<(typeof COMMANDS)[P], M, S>;
};
declare type WithModules<M extends RedisModules, S extends RedisScripts> = {
    [P in keyof M as M[P] extends never ? never : P]: {
        [C in keyof M[P]]: RedisClusterMultiCommandSignature<M[P][C], M, S>;
    };
};
declare type WithScripts<M extends RedisModules, S extends RedisScripts> = {
    [P in keyof S as S[P] extends never ? never : P]: RedisClusterMultiCommandSignature<S[P], M, S>;
};
export declare type RedisClusterMultiCommandType<M extends RedisModules = Record<string, never>, S extends RedisScripts = Record<string, never>> = RedisClusterMultiCommand & WithCommands<M, S> & WithModules<M, S> & WithScripts<M, S>;
export declare type RedisClusterMultiExecutor = (queue: Array<RedisMultiQueuedCommand>, firstKey?: string | Buffer, chainId?: symbol) => Promise<Array<RedisCommandRawReply>>;
export default class RedisClusterMultiCommand {
    #private;
    static extend<M extends RedisModules, S extends RedisScripts>(plugins?: RedisPlugins<M, S>): new (...args: ConstructorParameters<typeof RedisMultiCommand>) => RedisClusterMultiCommandType<M, S>;
    constructor(executor: RedisClusterMultiExecutor, firstKey?: string | Buffer);
    commandsExecutor(command: RedisCommand, args: Array<unknown>): this;
    addCommand(firstKey: string | Buffer | undefined, args: RedisCommandArguments, transformReply?: RedisCommand['transformReply']): this;
    scriptsExecutor(script: RedisScript, args: Array<unknown>): this;
    exec(execAsPipeline?: boolean): Promise<Array<RedisCommandRawReply>>;
    EXEC: (execAsPipeline?: boolean) => Promise<Array<RedisCommandRawReply>>;
    execAsPipeline(): Promise<Array<RedisCommandRawReply>>;
}
export {};
