"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.transformReply = exports.transformArguments = exports.IS_READ_ONLY = void 0;
const SEARCH_1 = require("./SEARCH");
const _1 = require(".");
exports.IS_READ_ONLY = true;
function transformArguments(index, query, options) {
    const args = ['FT.PROFILE', index, 'SEARCH'];
    if (options === null || options === void 0 ? void 0 : options.LIMITED) {
        args.push('LIMITED');
    }
    args.push('QUERY', query);
    (0, _1.pushSearchOptions)(args, options);
    return args;
}
exports.transformArguments = transformArguments;
function transformReply(reply) {
    return {
        results: (0, SEARCH_1.transformReply)(reply[0]),
        profile: (0, _1.transformProfile)(reply[1])
    };
}
exports.transformReply = transformReply;
