/// <reference types="node" />
import COMMANDS from './commands';
import { RedisCommand, RedisCommandArguments, RedisCommandReply, RedisModules, RedisPlugins, RedisScript, RedisScripts } from '../commands';
import { ClientCommandOptions, RedisClientCommandSignature, RedisClientOptions, WithModules, WithScripts } from '../client';
import { ClusterNode } from './cluster-slots';
import { EventEmitter } from 'events';
import { RedisClusterMultiCommandType } from './multi-command';
export declare type RedisClusterClientOptions = Omit<RedisClientOptions<Record<string, never>, Record<string, never>>, 'modules' | 'scripts'>;
export interface RedisClusterOptions<M extends RedisModules, S extends RedisScripts> extends RedisPlugins<M, S> {
    rootNodes: Array<RedisClusterClientOptions>;
    defaults?: Partial<RedisClusterClientOptions>;
    useReplicas?: boolean;
    maxCommandRedirections?: number;
}
declare type WithCommands = {
    [P in keyof typeof COMMANDS]: RedisClientCommandSignature<(typeof COMMANDS)[P]>;
};
export declare type RedisClusterType<M extends RedisModules = Record<string, never>, S extends RedisScripts = Record<string, never>> = RedisCluster<M, S> & WithCommands & WithModules<M> & WithScripts<S>;
export default class RedisCluster<M extends RedisModules = Record<string, never>, S extends RedisScripts = Record<string, never>> extends EventEmitter {
    #private;
    static extractFirstKey(command: RedisCommand, originalArgs: Array<unknown>, redisArgs: RedisCommandArguments): string | Buffer | undefined;
    static create<M extends RedisModules = Record<string, never>, S extends RedisScripts = Record<string, never>>(options?: RedisClusterOptions<M, S>): RedisClusterType<M, S>;
    constructor(options: RedisClusterOptions<M, S>);
    duplicate(overrides?: Partial<RedisClusterOptions<M, S>>): RedisClusterType<M, S>;
    connect(): Promise<void>;
    commandsExecutor(command: RedisCommand, args: Array<unknown>): Promise<RedisCommandReply<typeof command>>;
    sendCommand<C extends RedisCommand>(firstKey: string | Buffer | undefined, isReadonly: boolean | undefined, args: RedisCommandArguments, options?: ClientCommandOptions, bufferMode?: boolean, redirections?: number): Promise<RedisCommandReply<C>>;
    scriptsExecutor(script: RedisScript, args: Array<unknown>): Promise<RedisCommandReply<typeof script>>;
    executeScript(script: RedisScript, originalArgs: Array<unknown>, redisArgs: RedisCommandArguments, options?: ClientCommandOptions, redirections?: number): Promise<RedisCommandReply<typeof script>>;
    multi(routing?: string | Buffer): RedisClusterMultiCommandType<M, S>;
    getMasters(): Array<ClusterNode<M, S>>;
    getSlotMaster(slot: number): ClusterNode<M, S>;
    disconnect(): Promise<void>;
}
export {};
